<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Notes - V3</title>
    <style>
        *::-webkit-scrollbar {
            width: 5px;
        }

        ::-webkit-scrollbar-corner {
            background: rgba(0, 0, 0, 0);
            border-radius: 5px;
        }


        ::-webkit-scrollbar-track {
            background: transparent;
            border-radius: 15px;
            margin-top: 30px;
            margin-bottom: 30px;
            width: 5px;
        }

        *::-webkit-scrollbar-thumb {
            background: var(--sb-thumb-color);
            border-radius: 15px;
            width: 5px;
        }

        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #0F0F0F;
            color: #ffffff;
            padding: 20px;

        }

        .changelog {

            padding: 20px;
            border-radius: 10px;
        }

        h1 {
            margin-left: 10px;
        }

        .update {
            margin-bottom: 20px;
            padding: 10px;
            border-left: 4px solid #1E88E5;
            background-color: #2a2a2a;
            border-radius: 5px;
        }

        .version {
            font-weight: bold;
            color: #1E88E5;
        }

        .important {
            font-weight: bold;
            color: #F00;
        }

        li {
            margin: 0 0 10px 0;
        }

        .titlebrg {
            color: #1E88E5;
            font-weight: bold;
            font-size: 1.7rem;
        }

        .builder-msg-box {
            background-color: #f1f5f9;
            border: 1px solid #cbd5e1;
            padding: 16px;
            border-radius: 8px;
            max-width: 500px;
            margin: 20px auto;
            font-family: sans-serif;
        }

        .builder-msg-text {
            margin-bottom: 12px;
            font-size: 16px;
            color: #1e293b;
        }

        .builder-password-container {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }

        #builder-password-input {
            flex: 1;
            min-width: 200px;
            padding: 8px;
            font-size: 14px;
            border: 1px solid #94a3b8;
            border-radius: 6px;
            background-color: #e2e8f0;
            color: #1e293b;
        }

        .builder-copy-btn {
            padding: 8px 12px;
            font-size: 14px;
            background-color: #0ea5e9;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            white-space: nowrap;
        }

        .builder-copy-btn:hover {
            background-color: #0284c7;
        }

        @media (max-width: 480px) {
            .builder-password-container {
                flex-direction: column;
            }

            .builder-copy-btn {
                width: 100%;
            }
        }

        h4 {
            margin: 0;
            padding: 5px;
        }

        .manul-box {
            width: 100%;
            flex-direction: column;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 12px;
        }

        /* Input + Copy button container */
        .input-wrapper {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 6px;
            width: 95%;
            opacity: 0;
            transform: scale(0.95);
            pointer-events: none;
            ;
            height: 0px;
        }

        .input-wrapper.show {
            opacity: 1;
            transform: scale(1);
            pointer-events: auto;
            height: unset;
        }

        .input-row {
            display: flex;
            align-items: center;
            gap: 8px;
            width: 100%;
            justify-content: center;
        }

        /* Input styling */
        .input-row input {
            flex: 1;
            padding: 8px 12px;
            color: white;
            background: rgba(0, 0, 0, 0.7);
            border: 2px solid #00b4ff;
            border-radius: 8px;
            backdrop-filter: blur(15px);
            box-shadow: 0 0 6px rgba(0, 180, 255, 0.5);
            transition: box-shadow 0.3s ease;
        }

        .input-row input:focus {
            outline: none;
            box-shadow: 0 0 10px #00b4ff, 0 0 20px #00b4ff;
        }

        /* Buttons */
        .manul-box button,
        .copy-btn {
            padding: 8px 14px;
            background-color: transparent;
            border: 2px solid #00b4ff;
            border-radius: 6px;
            color: #00b4ff;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .manul-box button:hover,
        .copy-btn:hover {
            background-color: #00b4ff;
            color: black;
            box-shadow: 0 0 8px #00b4ff, 0 0 15px #00b4ff;
        }

        /* Smaller copy button */
        .copy-btn {
            flex-shrink: 0;
            padding: 8px 10px;
            width: 80px;
            text-align: center;
        }

        /* Hint text */
        .hint {
            font-size: 13px;
            color: #aaa;
            font-style: italic;
            text-align: left;
            width: 100%;
            padding-left: 4px;
        }
    </style>
</head>

<body onselectstart="return false;" ondragstart="return false;" oncontextmenu="return false;">
    <div class="changelog">
        <h1>BTMOB 3.6.3 Updates</h1>
		 <div class="update">
            <p class="version">Version V3.6.3 - New features added by ATM |  18 December 2025</p>
            <ul>
                <ul>
                    <li>Bug fixes on dropstub (server side)</li>
                    <li>Dropper now install payload without errors</li>
                    <li>Brazilian Banks Blockstyles more usable. Control directily from Screen Monitor</li>
                </ul>
            </ul>
        </div>
		        <div class="update">
            <p class="version">Version V3.6 | Patch-Update | 30 August 2025</p>
            <ul>
                <ul>
                    <li>Bug fixes and performance Improvements</li>
                    <li>Dropper + Main app, uses same load page</li>
                    <li>Main website only shows after permissions granted</li>
                    <li>improve microphone stability</li>
                    <p class="important">this update only for APK + Dropper, No EXE update.</p>
                </ul>
            </ul>
        </div>
        <div class="update">
            <p class="version">Version V3.6 | 23 August 2025</p>
            <div class="manul-box">

                <button onclick="toggleInput()" id="toggleBtn">Manual Update V3.6</button>

                <div id="inputWrapper" class="input-wrapper">
                    <svg xmlns="http://www.w3.org/2000/svg" width="120"
                        height="42" viewBox="0 0 294 42">
                        <defs>
                            <style>
                                .cls-1 {
                                    fill: #07f;
                                }

                                .cls-2 {
                                    fill: none;
                                }

                                .cls-3 {
                                    fill: #fff;
                                }

                                .cls-4 {
                                    fill: #ffffff;
                                }
                            </style>
                        </defs>
                        
                        <g id="full_color">
                            <g id="flame">
                                <path class="cls-1"
                                    d="M21.91,9.26a51.47,51.47,0,0,1,9.33,1c2.91.54,5.85,1.55,8.83,1.54,2.28,0,4.12-1.59,4.11-3.53S42.32,4.7,40,4.71a13.35,13.35,0,0,0-3.9.65c.33-.24.66-.48,1-.69A26.14,26.14,0,0,1,52.19,1C57.81,1.26,63.66,3,68,6.72a19.89,19.89,0,0,1,6.62,17.82A19.75,19.75,0,0,1,62.45,39.62,24,24,0,0,1,48,40.14c-6.21-1.57-11.64-5-17.48-7.53a46.86,46.86,0,0,0-10.57-2.68H20a9,9,0,0,0,4.11-.7c1.73-.83,1.72-2.83.82-4.29-1.07-1.74-3.23-2.45-5.09-3a24.36,24.36,0,0,0-10-.49A15.06,15.06,0,0,0,3,23.94,5.67,5.67,0,0,0,1.2,26.16c3.08-8.54,9.2-7.58,13-9.92a2.16,2.16,0,0,0-1.57-3.93,7.24,7.24,0,0,0-2.92,1.46l-.86.65S11.9,9.26,21.91,9.26Z" />
                                <path class="cls-2" d="M24.93,24.82l0,0,0,0Z" />
                                <path class="cls-3" d="M24.84,24.73l.06.06Z" />
                                <path class="cls-3"
                                    d="M57.3,14c-4.08,0-5.76,2.57-10.18,5-7.65,4.18-12.2,2.4-12.2,2.62s3.1,1.53,10.7,5.22A27,27,0,0,0,57.35,30h0a8,8,0,1,0,0-16Z" />
                            </g>
                            <g id="MediaFire">
                                <path class="cls-4"
                                    d="M87.63,6.31H101l.39,16.78h.09L110,6.31h13.68l-6.64,31.2h-8.92L113,16h-.09l-10.23,21.5H95.54L94.4,16h-.09L90,37.52H81.11Z" />
                                <path class="cls-4"
                                    d="M144.82,30.92c-.57,1.53-2.27,7.17-12.06,7.17-8,0-11.28-4.5-11.28-10,0-10.4,8-13.81,13.59-13.81,5,0,11.1,2.8,11.1,9.92a14.09,14.09,0,0,1-.44,3.93H129.57c0,2.4.83,4.41,3.54,4.41a3.7,3.7,0,0,0,3.41-1.62ZM138,23.62a4.3,4.3,0,0,0,.09-.74,3,3,0,0,0-3.28-3.06c-2.32,0-3.85,1.4-4.5,3.8Z" />
                                <path class="cls-4"
                                    d="M161.95,34.94h-.09a6.82,6.82,0,0,1-6,3.15c-7.3,0-8.3-6.47-8.3-9.22,0-8.61,4.5-14.6,11.28-14.6,2.62,0,5.07.79,6.55,3.36l2.36-11.32h8.65l-6.47,31.2h-8.48Zm1.16-10.18c0-2.53-.87-4.2-3.1-4.2-3.45,0-4.59,4.24-4.59,7.52,0,2.05.92,3.72,3.19,3.72C162,31.79,163.11,27.47,163.11,24.76Z" />
                                <path class="cls-4"
                                    d="M177.06,14.84h8.65L181,37.52h-8.65Zm9.13-2.45h-8.65l1.27-6.07h8.65Z" />
                                <path class="cls-4"
                                    d="M215.1,6.31h24.08l-1.78,8.52H222.93l-.83,3.89h12.28l-1.53,7.43H220.57L218.2,37.52h-9.61Z" />
                                <path class="cls-4" d="M239.8,14.84h8.65l-4.72,22.68h-8.65Z" />
                                <path class="cls-4"
                                    d="M291.2,24.19c0-7.12-6.07-9.92-11.1-9.92a14.74,14.74,0,0,0-8.16,2.45A11.84,11.84,0,0,0,268.08,21a15,15,0,0,0-1.57,7c0,5.51,3.23,10,11.27,10,9.79,0,11.49-5.64,12.06-7.17h-8.3a3.71,3.71,0,0,1-3.41,1.62c-2.71,0-3.54-2-3.54-4.41h16.17A14.09,14.09,0,0,0,291.2,24.19ZM283,23.62h-7.69c.66-2.4,2.18-3.8,4.5-3.8a3,3,0,0,1,3.28,3.06A4.37,4.37,0,0,1,283,23.62Z" />
                                <path class="cls-2" d="M265.81,22l.92-2A14.42,14.42,0,0,0,265.81,22Z" />
                                <path class="cls-4"
                                    d="M269.1,14.79a10.67,10.67,0,0,0-3.38-.52h-.06a8.52,8.52,0,0,0-2.5.41,9.55,9.55,0,0,0-4.56,3.69h-.09l.14-.66.61-2.88H250.9l-4.72,22.68h8.65L257.06,27c1-3.9,2.86-5.24,6.21-5.25h0a10.1,10.1,0,0,1,2.5.31Z" />
                                <path class="cls-4"
                                    d="M198.49,14.27c-5.55,0-10.23,1.4-11.58,7.43H195c.48-1.7,1.7-2.32,3.45-2.32,1.31,0,2.71.39,2.71,2,0,2.8-3.89,2.45-6.34,2.62-6.51.48-11,2.1-11,8.08,0,4.33,3.45,6,7.34,6,2.53,0,5.46-.92,7-2.75l.12-.16h0l-.48,2.35h8.28l3-14.16a23.15,23.15,0,0,0,.33-3.06C209.5,14.79,202.6,14.27,198.49,14.27Zm1.15,14.63C199,31.42,197.78,33,195.3,33c-1.4,0-2.75-.39-2.75-2s1.35-2.4,2.8-2.53a12.54,12.54,0,0,0,4.59-1Z" />
                                <polygon class="cls-4"
                                    points="248.93 12.39 240.28 12.39 241.54 6.31 250.2 6.31 248.93 12.39" />
                            </g>
                        </g>
                    </svg>
                    <div class="input-row">
                        <input id="manuallink" type="text"
                            value="https://www.mediafire.com/file/48f4s7js299iwju/BTMOB+v3.6.rar/file" readonly>
                        <button class="copy-btn" onclick="copyLink()">Copy</button>
                    </div>
                    <span class="hint">Extract Password: <b>T.ME/BT_MOB</b></span>
                </div>
            </div>
            <ul>
                <li class="titlebrg">Bots Manager</li>
                <ul>
                    <li>Automate actions on mobile devices</li>
                    <li>
                        Actions supported:
                        <ul>
                            <li>Click (text, ID, class, location)</li>
                            <li>Scroll (up, down, left, right)</li>
                            <li>Navigate (back, recent, home)</li>
                            <li>Sleep (delay in ms)</li>
                            <li>Open App/Link (browser or app)</li>
                            <li>Paste Text</li>
                            <li>Wait (text or app load)</li>
                            <li>Stealth Mode (ON/OFF)</li>
                            <li>Toggle options</li>
                        </ul>
                    </li>

                    <li>Examples:
                        <ul>
                            <li>Open app, scroll down, click button, repeat</li>
                            <li>Open link, go to Instagram, click Follow, navigate back</li>
                            <li>Post on Facebook, follow Instagram account, like post, repeat clicks</li>
                        </ul>
                    </li>
                    <li>Other features: Duplicate, reorder, save, edit, copy/paste, execute bots</li>
                    <li>Supports single or multiple clients</li>
                    <li>Shows bot status: Waiting, Running, Success, Fail, Abort</li>
                    <li>
                        <h4 class="titlebrg">Android Viewer</h4> (Bots Manager Help Tool) (view mobile screen structure:
                        text, ID, class, etc. via
                        ADB, requires USB + Debugging)
                    </li>
                </ul>

                <li class="titlebrg">Clone Manager</li>
                <ul>
                    <li>Full cloning system for apps</li>
                    <li>Clone any app (isolated from the original)</li>
                    <li>Supports all apps (system or user)</li>
                    <li>Automatically clone or remove apps</li>
                    <li>Open apps in clone mode</li>
                    <li>Anti-Delete Clone Engine from settings</li>
                </ul>

                <li class="titlebrg">Dropper Rework</li>
                <ul>
                    <li>Loads the main site and requests APK installation in a new style</li>
                    <li>Re-enabled anti-delete feature for Dropper</li>
                    <li>Dropper manages cloning and app communication (Clone engine)</li>
                </ul>

                <li class="titlebrg">Bypass Accessibility Detection (V2)</li>
                <ul>
                    <li>Now works with all apps, unlike the old version</li>
                </ul>

                <li class="titlebrg">Other Improvements</li>
                <ul>
                    <li>More encryption for APKs and droppers</li>
                    <li>Improved file manager with auto-load thumbnails</li>
                    <li>Enhanced hide permission tool</li>
                    <li>Fixed issues:
                        <ul>
                            <li>APK stops after 6 hours</li>
                            <li>SMS saving not working properly</li>
                            <li>Offline keylogger issues</li>
                            <li>Slow message search</li>
                        </ul>
                    </li>
                    <li>File Access: May appear grayed out on some phones – adjustments added to resolve issue</li>
                </ul>

                <li class="titlebrg">New Settings Options (Files)</li>
                <ul>
                    <li>Hide empty folders</li>
                    <li>Hide empty files</li>
                </ul>
            </ul>
        </div>

        <div class="update">
            <p class="version">Version V3.5 | Fix | 19 July 2025</p>
            <ul>
                <ul>
                    <li>Fix builder issue</li>
                    <li>Fix dropper issue</li>
                    <li>Fix google play warnings</li>
                    <li>More stable APP</li>

                </ul>
            </ul>
        </div>
        <div class="update">
            <!-- <div class="builder-msg-box">
                <p class="builder-msg-text">
                    The builder problems have been solved. If you still have issues, please update to the latest version
                    and try again.
                </p>

                <div class="builder-password-container">
                    <input type="text" readonly id="builder-password-input" value="mySecureFile123" />
                    <button onclick="copyBuilderPassword()" class="builder-copy-btn">Copy</button>
                </div>
            </div> -->
            <p class="version">Version V3.5 | 10 July 2025</p>
            <ul>
                <li class="titlebrg">Bypass Access Detection</li>
                <ul>
                    <li>New option in builder: Hide Accessibility → Add App ID to bypass detection</li>
                    <li>Tips for bypass:</li>
                    <ul>
                        <li>Use the package name provided by the builder</li>
                        <li>Don’t install and launch immediately; wait 15–30 minutes after installation</li>
                        <li>Target app must be installed before the BT app</li>
                    </ul>
                </ul>

                <li class="titlebrg">Builder Options</li>
                <ul>
                    <li>Protect APK</li>
                    <li>Pump APK Size</li>
                    <li>Inject JavaScript</li>
                    <li>Force Permissions – Repeatedly requests permissions until allowed</li>
                    <li>“App Tag” input added to identify and manage app versions</li>
                </ul>

                <li class="titlebrg">Panel Features</li>
                <ul>
                    <li>Enable/disable Anti-Delete (Manager > Options)</li>
                    <li>Added Shortcut Tools to the main panel</li>
                </ul>

                <li class="titlebrg">New Tools</li>
                <ul>
                    <li>Show Toast</li>
                    <li>Open Link</li>
                    <li>Text-to-Speech</li>
                    <li>Call Phone</li>
                    <li>Call Forwarding</li>
                    <li>Camera Flashlight Toggle (On/Off)</li>
                    <li>Built-in Ads Blocker when loading main site</li>
                    <li>File Manager: Play Sound</li>
                    <li>File Manager: Fast Download (video/image only; compresses files with FFmpeg, e.g., 100MB → 18MB
                        in 1 min)</li>
                </ul>

                <li class="titlebrg">Update Manager</li>
                <ul>
                    <li>View all clients and their APK versions</li>
                    <li>Send update requests with new link</li>
                    <li>Displays update window on app launch if update is available</li>
                </ul>

                <li class="titlebrg">SMS Manager</li>
                <ul>
                    <li>Shows contact names correctly</li>
                    <li>Displays sent and received message status</li>
                    <li>Select SIM card for sending SMS</li>
                </ul>

                <li class="titlebrg">Other Improvements</li>
                <ul>
                    <li>If Accessibility is enabled, “Draw Over Apps” permission is no longer required</li>
                    <li>Reintroduced Dark Theme</li>
                    <li>Bug fixes and performance improvements</li>
                </ul>
            </ul>
        </div>

        <div class="update">
            <p class="version">Version V3.4.1 | 26 May 2025</p>
            <ul>
                <li class="titlebrg">General</li>
                <ul>
                    <li>Improvements and Bug fixes</li>

                </ul>
            </ul>
        </div>
        <div class="update">
            <p class="version">Version V3.4 | 22 May 2025</p>
            <ul>
                <li class="titlebrg">Live Screen</li>
                <ul>
                    <li>Long press support added.</li>
                    <li>Recording feature added.</li>
                    <li>Improved speed and performance.</li>
                </ul>
            </ul>
            <ul>
                <li class="titlebrg">APK Improvements</li>
                <ul>
                    <li>Reduced APK size to 8MB (with dropper).</li>
                    <li>New APK encryption + Anti decompile.</li>
                    <li>Improved anti-delete functionality.</li>
                    <li>Fixed dropper stuck on "Installing"</li>
                    <li>Bug fixes and performance enhancements.</li>
                    <li>More accurate ping speed testing to server (ms).</li>
                    <li>Better background operation and connection stability.</li>
                </ul>
            </ul>
            <ul>
                <li class="titlebrg">Black Screen (New Block Modes)</li>
                <ul>
                    <li>Normal (Black)</li>
                    <li>System Update</li>
                    <li>Device Locked</li>
                    <li>Battery Died</li>
                </ul>
            </ul>
            <ul>
                <li class="titlebrg">Injection Lab</li>
                <ul>
                    <li>View all injections (Preview + Editor).</li>
                    <li>Edit, save, add, or remove injections.</li>
                </ul>
            </ul>
            <ul>
                <li class="titlebrg">Saved Login Info</li>
                <ul>
                    <li>2FA is not required on every login, only in certain cases.</li>
                    <li>To switch accounts, go to Settings > Logout.</li>
                </ul>
            </ul>
            <ul>
                <li class="titlebrg">General</li>
                <ul>
                    <li>Full and automatic Injection System.</li>
                    <li>Shows real-time connection speed to the server.</li>
                    <li>Hide Permission Screen Redesigned.</li>
                    <li>Fixed live notifications weren't showing in BTMOB.</li>
                    <li>Redirect clients to a new server or email account.</li>
                    <li>SMS Sending Function: send SMS using all detected SIM cards.</li>
                    <li>Offline Keylogs : Auto Save,,Download All,Delete All</li>
                    <li>Bug fixes and performance enhancements.</li>
                </ul>


            </ul>
        </div>
        <div class="update">
            <p class="version">Version V3.3 | 24 April 2025</p>
            <ul>
                <li>Improved anti-delete and anti-reset accessibility</li>
                <li>Enhanced APK stability and connection</li>
                <li>Added Spanish and Portuguese for the Request Accessibility page</li>
                <li>New Request Accessibility page for Samsung devices</li>
                <li>Update Accessibility page design</li>
                <li>Return the "Fake Uninstall" option to hide the icon</li>
                <li>New APK signature</li>
                <li>Updated APK and dropper encryption</li>
            </ul>
        </div>
        <div class="update">
            <p class="version">APK UPDATE V3.2.1 | 15 April 2025</p>
            <ul>
                <li>General Apk optimization</li>
            </ul>
        </div>
        <div class="update">
            <p class="version">Version 3.2 , 13 April 2025 </p>
            <ul>
                <li>Added live location monitoring</li>
                <li>Optimized and improved the APK</li>
                <li>APK Fixed bugs</li>
                <li>APK new encryption</li>
                <li>start live screen even when the screen is locked</li>
                <li>Live screen will auto-reconnect if the connection is lost</li>
                <li>Added "Connection Key" on RAT login</li>
                <li>Updated the Dropper</li>
                <li>Dropper new encryption</li>
                <li>Dropper don't hides its icon; it launches the main APK</li>
                <li>General bug fixes and improvements</li>
                <li>Tip: Use Dropper with "Hide Icon" option</li>
                </br>
                <li>Disabled BTMOB device hardware lock – you can now change your PC anytime</li>
                </br>
                <p class="important">use BTMOB v3.2 to build apk, old versions does not support Connection Key.</p>

            </ul>
        </div>
        <div class="update">
            <p class="version">Version 3 Fix , 30 March 2025</p>
            <ul>
                <li>Fix Accessibility crash after mobile restart</li>
                <li>Fix issue live screen not always works</li>
                <li>Performance and bug fixes</li>
            </ul>
        </div>
        <div class="update">
            <p class="version">Version 3.0 , 27 March 2025</p>
            <ul>
                <li>Automatic RAT updates</li>
                <li>Full auto-permission support for Android 14 & 15</li>
                <li>Major performance improvements</li>
                <li>Updated RAT login UI</li>
                <li>Suppress accessibility usage warning</li>
                <li>Interface improvements</li>
                <li>Apktool updated to v2.11.1</li>
                <li>New APK encryption</li>
                <li>General fixes and improvements</li>
                <li>Capture Alipay PIN</li>
                <li>App hide icon if user try to delete the app</li>
                <li>Automatically hide notification</li>
                <li>Improve connection stability</li>
                <li>Reworked “Guide” accessibility install method</li>
            </ul>
        </div>
        <div class="update">
            <p class="version">Version 2.9</p>
            <ul>
                <li>Videos: APK install with/without black screen</li>
                <li>Android 15 support</li>
                <li>Optional Notification Permission</li>
                <li>Anti-Factory Reset</li>
                <li>Auto-disable Google Play</li>
                <li>Hide permissions with black screen</li>
                <li>Performance and bug fixes</li>
            </ul>
        </div>

        <div class="update">
            <p class="version">Version 2.7</p>
            <ul>
                <li>Videos demonstrating auto permissions and Anti-Delete</li>
                <li>BT Panel: Edit/Rename client, Notes, Redirect, save APK builder config</li>
                <li>APK: Light & Angle sensor monitors</li>
                <li>Fixes: Camera/mic block detection, screen wake-up, permissions, Anti-Delete</li>
            </ul>
        </div>

        <div class="update">
            <p class="version">Version 2.5.5</p>
            <ul>
                <li>Dropper encryption update</li>
                <li>New loading screen</li>
                <li>Permission request removed from Dropper</li>
                <li>Dropper auto-installs & hides icon</li>
                <li>Fixes for high client volume issues and black screen bugs</li>
            </ul>
        </div>


        <div class="update">
            <p class="version">Version 2.5.2</p>
            <ul>
                <li>Server availability fixes</li>
                <li>Direct connection to server (no proxy/domain)</li>
                <li>Multiple global servers released</li>
                <li>General improvements</li>
            </ul>
        </div>

        <div class="update">
            <p class="version">Version 2.5</p>
            <ul>
                <li>SDK updated to Android 14</li>
                <li>Removed sticky notification</li>
                <li>Main website loads after permission grant</li>
                <li>Lock screen capture fully fixed</li>
                <li>Auto-grant file and draw-over permissions</li>
                <li>Live Screen: Silent mode black screen</li>
                <li>Added HTML APK injection + status icon</li>
                <li>Screen Reader with font size/color support</li>
                <li>Login window: Custom server input</li>
            </ul>
        </div>

        <div class="update">
            <p class="version">BTMOB V2 Release</p>
            <ul>
                <li><strong>Core Updates:</strong></li>
                <li>Redesigned with multi-threaded connections for better speed</li>
                <li>Dedicated connections for high-speed tools</li>
                <li>Dark UI theme and improved interface</li>
                <li>Auto-save for data (apps, SMS, contacts)</li>

                <li><strong>File Manager Updates:</strong></li>
                <li>FastObjListView for better performance</li>
                <li>Better search, preview support, built-in video player</li>
                <li>Enhanced download control</li>

                <li><strong>Lock Screen Tool:</strong> 4/6 digit PIN, Password support</li>

                <li><strong>Apps Manager:</strong> New columns, options to lock/track apps</li>

                <li><strong>General Enhancements:</strong></li>
                <li>APK improvements, lag fixes, connection stability</li>
                <li>Prevent Sleep Tool update</li>
            </ul>
        </div>

        <div class="update">
            <p class="version">BTMOB Update 1.7</p>
            <ul>
                <li>Video 1: Testing Android 13 Xiaomi</li>
                <li>Video 2: Testing Android 11 Samsung</li>
                <li>New Tool: Lock Screen (PIN + Pattern support, customizable)</li>
                <li>Bug fixes and improvements</li>
            </ul>
        </div>

        <div class="update">
            <p class="version">BTMOB Initial Features</p>
            <ul>
                <li>No port needed</li>
                <li>No VPN needed</li>
                <li>Powerful & Easy to use</li>
                <li>Clients page</li>
                <li>Screens Page: View multiple screen at same time</li>
                <li>Alerts page: view notification/alerts from clients</li>
                <li>Connections page</li>
                <li>Block list page</li>
                <li>Broadcast Manager: Send alerts/notifications with actions</li>
                <li>All tools contain search bar (files, apps, SMS, etc.)</li>
                <li>1 Manager: Full phone control, settings, permissions, offline data</li>
                <li>2 File Manager: Previews, scanning, full file control</li>
                <li>3 Live Screen: Multiple modes, control, quality/audio options</li>
                <li>4 Live Camera</li>
                <li>5 Live Microphone + record</li>
                <li>6 Read and Send Messages</li>
                <li>7 Read/Add/Delete contacts</li>
                <li>8 Apps Manager: Manage and track apps</li>
                <li>9 Live keylogger</li>
                <li>10 Web Browser: Hidden browser, login capture</li>
                <li>11 Tracking Manager</li>
                <li>12 Live chat</li>
                <li>13 Manage clients: Block/restart/stop app/uninstall</li>
            </ul>
        </div>


    </div>


</body>
<script>
    function copyBuilderPassword() {
        const input = document.getElementById('builder-password-input');
        input.select();
        input.setSelectionRange(0, 99999); // For mobile
        document.execCommand("copy");

        // Optional: alert or change button text briefly
        alert("Password copied to clipboard!");
    }
    function toggleInput() {
        const wrapper = document.getElementById("inputWrapper");
        const btn = document.getElementById("toggleBtn");
        wrapper.classList.toggle("show");
        btn.textContent = wrapper.classList.contains("show") ? "Hide" : "Manual Update";
    }

    function copyLink() {
        const input = document.getElementById("manuallink");
        input.select();
        input.setSelectionRange(0, 99999); // mobile support
        navigator.clipboard.writeText(input.value).then(() => {
            const btn = document.querySelector(".copy-btn");
            btn.textContent = "Copied!";
            setTimeout(() => btn.textContent = "Copy", 1500);
        });
    }
</script>

</html>